const http = require('http');
const fs = require('fs');
const path = require('path');

// Erstellen oder Anhängen an die Logdatei im Anhängemodus
const logFile = fs.createWriteStream(path.join(__dirname, 'access.log'), { flags: 'a' });

http.createServer(function (request, response) {
    // Log-Eintrag für jede eingehende Anfrage erstellen
    const logEntry = `${new Date().toISOString()} - ${request.method} ${request.url} - ${request.headers['user-agent']}\n`;
    logFile.write(logEntry);

    if (request.method === 'POST' && request.url === '/submit-form') {
        let body = '';
        
        // Eingehende Daten verarbeiten
        request.on('data', chunk => {
            body += chunk.toString(); // Wandelt Buffer in String um
        });

        request.on('end', () => {
            console.log('Formulardaten:', body);
            response.writeHead(200, { 'Content-Type': 'text/plain' });
            response.end('Formular erfolgreich eingereicht!');
        });

    } else {
        console.log('Anfrage für: ', request.url);

        // Den Pfad zur angeforderten Datei ermitteln
        let filePath;
        if (request.url === '/') {
            filePath = path.join(__dirname, 'index.html');
        } else {
            filePath = path.join(__dirname, request.url);
        }

        const extname = String(path.extname(filePath)).toLowerCase();
        const mimeTypes = {
            '.html': 'text/html',
            '.js': 'application/javascript',
            '.css': 'text/css',
            '.json': 'application/json',
            '.png': 'image/png',
            '.jpg': 'image/jpeg',
            '.gif': 'image/gif',
            '.wav': 'audio/wav',
            '.mp4': 'video/mp4',
            '.woff': 'application/font-woff',
            '.ttf': 'application/font-ttf',
            '.eot': 'application/vnd.ms-fontobject',
            '.otf': 'application/font-otf',
            '.svg': 'application/image/svg+xml'
        };

        const contentType = mimeTypes[extname] || 'application/octet-stream';

        // Datei lesen und ausliefern
        fs.readFile(filePath, function (error, content) {
            if (error) {
                if (error.code == 'ENOENT') {
                    response.writeHead(404, { 'Content-Type': 'text/plain' });
                    response.end('404 Not Found\n', 'utf-8');
                } else {
                    response.writeHead(500, { 'Content-Type': 'text/plain' });
                    response.end('Serverfehler: ' + error.code + '\n', 'utf-8');
                }
            } else {
                response.writeHead(200, { 'Content-Type': contentType });
                response.end(content, 'utf-8');
            }
        });
    }

}).listen(8080);

console.log('Der Server läuft auf: http://localhost:8080/');